<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;

class Invoices extends Model 
{

    protected $table = 'invoices';
    public $timestamps = true;

    use SoftDeletes;

    protected $dates = ['deleted_at'];
    protected $fillable = array('reservation_id', 'property_id', 'price', 'total_price', 'tax', 'cleanup_fees', 'service_fees', 'sale_code', 'points');

    public function bookings()
    {
        return $this->hasMany('App\Models\Booking');
    }

    public function reservation()
    {
        return $this->belongsTo('App\Models\Reservation');
    }

    public function property()
    {
        return $this->belongsTo('App\Models\Property');
    }

}